import { format } from "date-fns";

export function potentialDateToHourAndMinuteFormatter(value: unknown) {
  if (typeof value !== 'string' && typeof value !== 'number' && !(value instanceof Date)) {
    return 'N/A';
  }

  return format(value, "p")
}

export function potentialDateToDateStringFormatter(value: unknown) {
  if (typeof value !== 'string' && typeof value !== 'number' && !(value instanceof Date)) {
    return 'N/A';
  }

  return format(value, "PPPP p")
}
